import sqlite3
import psycopg2
import re
from datetime import datetime

# Change these
SQLITE_DB = "forgejo.db"
DB_NAME = "forgejodb"
DB_USER = "forgejo"
DB_PASS = "hunter2"
DB_HOST = "localhost"
DB_PORT = "5432"

rules = {x.split("\n")[0].strip(): x.split("\n")[1].strip().split(", ") for x in re.split(r'\n\s*\n', open("lol").read().strip())}

print("[OK] Rules loaded.")

# Prefix: !
def timestamp_conversion(ts):
    if not ts:
        return None
    return datetime.strptime(ts, "%Y-%m-%d %H:%M:%S")

# Prefix: *
def int_to_bool(integ):
    return integ == 1

# Dry run, verify the thingies all exist

print("[...] Starting dry run...")

sqdb = sqlite3.connect(SQLITE_DB)
sqursor = sqdb.cursor()

for table, col in rules.items():
    colstring = ", ".join(["\"" + x.replace("*", "").replace("!", "") + "\"" for x in col])
    items = sqursor.execute(f"SELECT {colstring} FROM {table};").fetchall()
    for row in items:
        newrow = []
        for i, cols in enumerate(col):
            if cols[0] == "*":
                newrow.append(int_to_bool(row[i]))
            elif cols[0] == "!":
                newrow.append(timestamp_conversion(row[i]))

bad = 0

for table, col in rules.items():
    sqursor.execute(f"PRAGMA table_info({table});")
    tables_there = sqursor.fetchall()
    if len(col) != len(tables_there):
        extras = [x[1] for x in tables_there]
        for i in col:
            extras.remove(i.replace("*", "").replace("!", ""))
        print("[!!!] " + table + f" extra columns: {extras}")
        bad += 1

if bad:
    print(f"[!!!] {bad} tables found with not enough items")

input("Press enter to start, press ctrl+c to stop...")

conn = psycopg2.connect(database=DB_NAME,
    user=DB_USER,
    password=DB_PASS,
    host=DB_HOST,
    port=DB_PORT)

cursor = conn.cursor()

for table, col in rules.items():
    print("[...] Working on " + table, end="", flush=True)
    colstring = ", ".join(["\"" + x.replace("*", "").replace("!", "") + "\"" for x in col])
    ph = ", ".join(["%s"] * len(col))
    items = sqursor.execute(f"SELECT {colstring} FROM {table};").fetchall()
    for row in items:
        newrow = []
        for i, cols in enumerate(col):
            if cols[0] == "*":
                newrow.append(int_to_bool(row[i]))
            elif cols[0] == "!":
                newrow.append(timestamp_conversion(row[i]))
            else:
                newrow.append(row[i])
        cursor.execute(f"INSERT INTO \"{table}\" ({colstring}) VALUES ({ph})", newrow)
    print("\r[OK] Done working on " + table)

print("Fixing sequences..")
seqs = sqursor.execute("SELECT * FROM sqlite_sequence").fetchall()
for table, seq in seqs:
    if seq:
        cursor.execute(f"SELECT setval(%s, %s, true);", (f"{table}_id_seq", seq))

conn.commit()
print("[FIN] Migration is done! Enjoy!")