from PIL import Image
import requests
from io import BytesIO
imraw = requests.get("https://cdn.swee.codes/charimgs/altsweecat5.png").content
im = Image.open(BytesIO(imraw)).convert("RGBA")
if im.width > 64:
    new_height = int((64 / im.width) * im.height)
    im = im.resize((64, new_height))
px = im.load()
sz = im.size
scif = open("e.ascii", "wb")
empty = 128
def rgb2irc(r, g, b):
    palette = [
        (255, 255, 255), (0, 0, 0),
        (0, 0, 127), (0, 147, 0),
        (255, 0, 0), (127, 0, 0),
        (156, 0, 156), (252, 127, 0),
        (255, 255, 0), (0, 252, 0),
        (0, 147, 147), (0, 255, 255),
        (0, 0, 252), (255, 0, 255),
        (127, 127, 127), (210, 210, 210),
    ]
    return min(range(16), key=lambda i: (r - palette[i][0])**2 + (g - palette[i][1])**2 + (b - palette[i][2])**2)
for y in range(0, im.height, 2):
    row = ""
    for x in range(im.width):
        r, g, b, a = px[x, y]
        if y + 1 < im.height:
            r1, g1, b1, a1 = px[x, y+1]
        else:
            r1, g1, b1, a1 = 0, 0, 0, 0
        top = a >= empty
        bot = a1 >= empty
        # Top block will be used if both exist
        if top and bot:
            ctop = rgb2irc(r,g,b)
            cbot = rgb2irc(r1,g1,b1)
            row += f"\x03{ctop},{cbot}▀"
        elif top:
            c = rgb2irc(r,g,b)
            row += f"\x03{c},99▀"
        elif bot:
            c = rgb2irc(r1,g1,b1)
            row += f"\x03{c},99▄"
        else:
            row += "\x0f "
    scif.write((row + "\n").encode("utf-8"))
scif.close()