# How to run
# python3 roundcubeupdate.py
#
# You may need to run as root or www-data
#
# sudo -u www-data python3 roundcubeupdate.py
#
# sudo python3 roundcubeupdate.py

from tqdm import tqdm
import requests
import sys
import os
import tarfile
print("Checking latest version...")
req = requests.get("https://api.github.com/repos/roundcube/roundcubemail/releases/latest").json()
latest = req["tag_name"]
download = ""
for asset in req["assets"]:
    if asset["name"] == f"roundcubemail-{latest}-complete.tar.gz":
        download = asset["browser_download_url"]

print(f"Latest: {latest}")
print(f"Download Exists: {download != ''}")

try:
    current = open("/var/www/roundcube/index.php").read().split("Version ")[1].split(" ")[0]
except:
    current = 0
print(f"Current: {current if current != 0 else 'Not installed!'}")
if current == 0:
    sys.exit(1)
if current == latest:
    print("No need to update.")
    sys.exit()

print("Downloading latest version...")

response = requests.get(download, stream=True)

total_size = int(response.headers.get("content-length", 0))
block_size = 1024

os.mkdir("roundcube.part")

with tqdm(total=total_size, unit="B", unit_scale=True, leave=False) as progress_bar:
    with open("roundcube.part/rc.tar.gz", "wb") as file:
        for data in response.iter_content(block_size):
            progress_bar.update(len(data))
            file.write(data)

file = tarfile.open('roundcube.part/rc.tar.gz')
file.extractall('./roundcube.part')
file.close()

os.chdir("roundcube.part")
os.system(f"./roundcubemail-{latest}/bin/installto.sh -y /var/www/roundcube")
os.chdir("..")
os.system("rm -r roundcube.part")
