# HOW TO USE THIS SCRIPT
# download this file and run
# python3 forgejoupdate.py
# 
# If you use an init system to run Forgejo, you can let this script automatically restart Forgejo for you
# (Assuming Forgejo's service name is `forgejo`)
# By passsing the arguments `systemd` or `openrc`
# 
# python3 forgejoupdate.py systemd

from tqdm import tqdm
import requests
import subprocess
import sys
import hashlib
import os
import stat
print("Checking latest version...")
req = requests.get("https://codeberg.org/api/v1/repos/forgejo/forgejo/releases/latest").json()
latest = req["tag_name"][1:]
download = ""
sha = ""
for asset in req["assets"]:
    if asset["name"] == f"forgejo-{latest}-linux-amd64":
       download = asset["browser_download_url"]
    if asset["name"] == f"forgejo-{latest}-linux-amd64.sha256":
       sha = requests.get(asset["browser_download_url"]).content.decode().strip().split(" ")[0]

print(f"Latest: {latest}")
print(f"Download Exists: {download != ''}")
print(f"Checksum Exists: {sha != ''}")

# 5
try:
    current = subprocess.run(["forgejo", "-v"], stdout=subprocess.PIPE).stdout.decode().strip().split(" ")[5][:-1]
except:
    current = 0
print(f"Current: {current if current != 0 else 'Not installed!'}")
if current == latest:
    print("No need to update.")
    sys.exit()

print("Downloading latest version...")

response = requests.get(download, stream=True)

total_size = int(response.headers.get("content-length", 0))
block_size = 1024

h = hashlib.sha256()

with tqdm(total=total_size, unit="B", unit_scale=True, leave=False) as progress_bar:
    with open("forgejo.part", "wb") as file:
        for data in response.iter_content(block_size):
            progress_bar.update(len(data))
            file.write(data)
            h.update(data)

if sha != h.hexdigest():
    print(f"ERROR: SHA256 doesn't match! {hex} ≠ {h.hexdigest()}")
    os.remove("forgejo.part")
    sys.exit(1)
else:
    print("Checksum verify success!")

os.chmod("forgejo.part", stat.S_IXOTH | stat.S_IROTH | stat.S_IWUSR)

os.rename("forgejo.part", "/usr/local/bin/forgejo")

if len(sys.argv) == 2:
    print("Restarting...")
    if sys.argv[1] == "systemd":
        os.system("systemctl restart forgejo")
    elif sys.argv[1] == "openrc":
        os.system("rc-service forgejo restart")
